/* Night (night2)
 * 1/30/2026
 * Version 2.3
 * Jon Siragusa <jon@centaur.pw>
 * https://www.centaur.pw/
 *
 * Copyright (C) Centaur, 2026. All Rights Reserved.
 *
 * night2.h
 */

#ifndef _NIGHT2_H
#define _NIGHT2_H

#include <cstring>
#include <cerrno>
#include <fstream>
#include <iostream>
#include <string>
#include <sstream>
#include <sys/ioctl.h>

using namespace std;

#define NIGHT_VERSION "2.3"

/* Comment out the line below to disable support for Night 1.X codes */

#define SUPPORT_OLD_CODES 1

/* Change the value of BOX_STYLE below to 0 to use more simplistic line borders */

#ifndef BOX_STYLE
	#define BOX_STYLE 1
#endif /* BOX_STYLE */

/* Change the value of MAX_LINES to set the upper limit of newlines within a box */

#define MAX_LINES 40

/* Box elements */

#if (defined(BOX_STYLE) && BOX_STYLE == 1)
	#define BOX_TOP_LEFT_CORNER	"┌"
	#define BOX_TOP_RIGHT_CORNER 	"┐"
	#define BOX_BOTTOM_LEFT_CORNER	"└"
	#define BOX_BOTTOM_RIGHT_CORNER	"┘"
	#define BOX_HORIZONTAL_LINE	"─"
	#define BOX_VERTICAL_LINE 	"│"
#else
	#define BOX_TOP_LEFT_CORNER	"+"
	#define BOX_TOP_RIGHT_CORNER 	"+"
	#define BOX_BOTTOM_LEFT_CORNER	"+"
	#define BOX_BOTTOM_RIGHT_CORNER	"+"
	#define BOX_HORIZONTAL_LINE	"-"
	#define BOX_VERTICAL_LINE 	"|"
#endif

#ifndef STDOUT_FILENO
	#define STDOUT_FILENO 1
#endif /* STDOUT_FILENO */

#define PROGRAM_HELP \
"Night codes contained in text will be converted to ANSI sequences.\n\
\n\
Full documentation for this program is maintained in the manual file;\n\
see: man night2\n\n\
The table below shows all valid Night2 codes:\n\
\n\
Color/Style         Night Code    Equivalent Character Sequence\n\
\n\
Foreground Black    :black:       \\e[30m\n\
Foreground Red      :red:         \\e[31m\n\
Foreground Green    :green:       \\e[32m\n\
Foreground Yellow   :yellow:      \\e[33m\n\
Foreground Blue     :blue:        \\e[34m\n\
Foreground Purple   :purple:      \\e[35m\n\
Foreground Cyan     :cyan:        \\e[36m\n\
Foreground White    :white:       \\e[37m\n\
Background Black    :bgblack:     \\e[40m\n\
Background Red      :bgred:       \\e[41m\n\
Background Green    :bggreen:     \\e[42m\n\
Background Yellow   :bgyellow:    \\e[43m\n\
Background Blue     :bgblue:      \\e[44m\n\
Background Purple   :bgpurple:    \\e[45m\n\
Background Cyan     :bgcyan:      \\e[46m\n\
Background White    :bgwhite:     \\e[47m\n\
Bold Text           :bold:        \\e[1m\n\
Faint Text          :faint:       \\e[2m\n\
Italic Text         :italic:      \\e[3m\n\
Underline Text      :underline:   \\e[4m\n\
Strikeout Text      :strike:      \\e[9m\n\
Clear Screen        :clear:       \\e[2J\n\
Reset Cursor        :cursor:      \\e[;H\n\
Reverse Video       :reverse:     \\e[7m\n\
Reset All           :reset:       \\e[0m\n\
Begin Center Text   :center:      N/A\n\
End Center Text     :.center:     N/A\n\
Begin Box           :box:         N/A\n\
End Box             :.box:        N/A\n\
Save Cursor         :start:       \\e7\n\
Restore Cursor      :restore:     \\e8\n\
Cursor Up           :up:          \\e[1A\n\
Cursor Down         :down:        \\e[1B\n\
Cursor Left         :left:        \\e[1D\n\
Cursor Right        :right:       \\e[1C\n\
New Line            :newline:     \\n\n\
None                :none:        Space + \\b\n\
\n\
By default, old (version 1.X) codes will also be processed unless this\n\
option was turned off before compiling.\
"

#define TEST_PATTERN \
"Night Test Pattern\n\n\
:black:Normal Black    :bold:Bold Black:reset:    :bgblack:Background Black:reset:\n\
:red:Normal Red      :bold:Bold Red:reset:      :bgred:Background Red:reset:\n\
:green:Normal Green    :bold:Bold Green:reset:    :bggreen:Background Green:reset:\n\
:yellow:Normal Yellow   :bold:Bold Yellow:reset:   :bgyellow:Background Yellow:reset:\n\
:blue:Normal Blue     :bold:Bold Blue:reset:     :bgblue:Background Blue:reset:\n\
:purple:Normal Purple   :bold:Bold Purple:reset:   :bgpurple:Background Purple:reset:\n\
:cyan:Normal Cyan     :bold:Bold Cyan:reset:     :bgcyan:Background Cyan:reset:\n\
:white:Normal White    :bold:Bold White:reset:    :bgwhite::black:Background White:reset:\n\
Normal Gray     :bold:Bold Gray:reset:\n\
:faint:Faint Text:reset:\n\
:italic:Italic Text:reset:\n\
:underline:Underlined Text:reset:\n\
:strike:Struck Text:reset:\n\
:reverse: Text:reset:\n\
"

/* Legacy Night codes */

#if (defined(SUPPORT_OLD_CODES) && SUPPORT_OLD_CODES == 1)
	#define Night1_Code_Black    "~BLAK"
	#define Night1_Code_Red      "~REDX"
	#define Night1_Code_Green    "~GREE"
	#define Night1_Code_Yellow   "~YELL"
	#define Night1_Code_Blue     "~BLUE"
	#define Night1_Code_Purple   "~PURP"
	#define Night1_Code_Cyan     "~CYAN"
	#define Night1_Code_White    "~WHIT"
	#define Night1_Code_Bold     "~BLD"
	#define Night1_Code_Line     "~LIN"
	#define Night1_Code_Clear    "~CLR"
	#define Night1_Code_Cursor   "~CUR"
	#define Night1_Code_Reverse  "~REV"
	#define Night1_Code_Reset    "~RES"
#endif /* SUPPORT_OLD_CODES */

/* Night2 codes */

#define Code_Black		":black:"
#define Code_Red		":red:"
#define Code_Green		":green:"
#define Code_Yellow		":yellow:"
#define Code_Blue		":blue:"
#define Code_Purple		":purple:"
#define Code_Cyan		":cyan:"
#define Code_White		":white:"
#define Code_BGBlack		":bgblack:"
#define Code_BGRed		":bgred:"
#define Code_BGGreen		":bggreen:"
#define Code_BGYellow		":bgyellow:"
#define Code_BGBlue		":bgblue:"
#define Code_BGPurple		":bgpurple:"
#define Code_BGCyan		":bgcyan:"
#define Code_BGWhite		":bgwhite:"
#define Code_Bold		":bold:"
#define Code_Faint		":faint:"
#define Code_Italic		":italic:"
#define Code_Line		":underline:"
#define Code_Strike		":strike:"
#define Code_Clear		":clear:"
#define Code_Cursor		":cursor:"
#define Code_Reverse		":reverse:"
#define Code_Reset		":reset:"
#define Code_NewLine		":newline:"
#define Code_BeginCenter	":center:"
#define Code_EndCenter		":.center:"
#define Code_BeginBox		":box:"
#define Code_EndBox		":.box:"
#define Code_Start		":start:"
#define Code_Restore		":restore:"
#define Code_Up			":up:"
#define Code_Down		":down:"
#define Code_Left		":left:"
#define Code_Right		":right:"
#define Code_None		":none:"

/* ANSI sequences */

#define BLACK		"\e[30m"
#define RED		"\e[31m"
#define GREEN		"\e[32m"
#define YELLOW		"\e[33m"
#define BLUE		"\e[34m"
#define PURPLE		"\e[35m"
#define CYAN		"\e[36m"
#define WHITE		"\e[37m"
#define BGBLACK		"\e[40m"
#define BGRED		"\e[41m"
#define BGGREEN		"\e[42m"
#define BGYELLOW	"\e[43m"
#define BGBLUE		"\e[44m"
#define BGPURPLE	"\e[45m"
#define BGCYAN		"\e[46m"
#define BGWHITE		"\e[47m"
#define BOLD		"\e[1m"
#define FAINT		"\e[2m"
#define ITALIC		"\e[3m"
#define LINE		"\e[4m"
#define STRIKE		"\e[9m"
#define CLEAR		"\e[2J"
#define CURSOR		"\e[;H"
#define REVERSE		"\e[7m"
#define RESET		"\e[0m"
#define NEWLINE		"\x0a"
#define START		"\e7"
#define RESTORE		"\e8"
#define UP		"\e[1A"
#define DOWN		"\e[1B"
#define LEFT		"\e[1D"
#define RIGHT		"\e[1C"
#define NONE		" \x08"

/* Code arrays */

string ansi_array[] = 
{
	BLACK, RED, GREEN, YELLOW, BLUE, PURPLE, CYAN, WHITE,
	BGBLACK, BGRED, BGGREEN, BGYELLOW, BGBLUE, BGPURPLE, BGCYAN, BGWHITE,
	BOLD, FAINT, ITALIC, LINE, STRIKE, CLEAR, CURSOR, REVERSE, RESET,
	NEWLINE, START, RESTORE, UP, DOWN, LEFT, RIGHT, NONE
};

int ansi_array_count = sizeof(ansi_array) / sizeof(ansi_array[0]);

string night2_array[] =
{
	Code_Black, Code_Red, Code_Green, Code_Yellow,
	Code_Blue, Code_Purple, Code_Cyan, Code_White,
	Code_BGBlack, Code_BGRed, Code_BGGreen, Code_BGYellow,
	Code_BGBlue, Code_BGPurple, Code_BGCyan, Code_BGWhite,
	Code_Bold, Code_Faint, Code_Italic, Code_Line,
	Code_Strike, Code_Clear, Code_Cursor, Code_Reverse, Code_Reset, 
	Code_NewLine, Code_Start, Code_Restore, Code_Up, Code_Down,
	Code_Left, Code_Right, Code_None
};

int night2_array_count = sizeof(night2_array) / sizeof(night2_array[0]);

#if (defined(SUPPORT_OLD_CODES) && SUPPORT_OLD_CODES == 1)
string old_ansi_array[] =
{
	BLACK, RED, GREEN, YELLOW, BLUE, PURPLE, CYAN, WHITE,
	BOLD, LINE, CLEAR, CURSOR, REVERSE, RESET
};

int old_ansi_array_count = sizeof(old_ansi_array) / sizeof(old_ansi_array[0]);

string night1_array[] = 
{
	Night1_Code_Black, Night1_Code_Red, Night1_Code_Green, Night1_Code_Yellow,
	Night1_Code_Blue, Night1_Code_Purple, Night1_Code_Cyan, Night1_Code_White,
	Night1_Code_Bold, Night1_Code_Line, Night1_Code_Clear, Night1_Code_Cursor,
	Night1_Code_Reverse, Night1_Code_Reset
};

int night1_array_count = sizeof(night1_array) / sizeof(night1_array[0]);
#endif /* SUPPORT_OLD_CODES */

/* Global variables */

struct winsize console_size;
int _c = ioctl(STDOUT_FILENO, TIOCGWINSZ, &console_size);
int line_count = 0;

/* Function declarations */

/* Returns the number of lines in str */
int lines(string str);

/* Returns an array of strings gathered from str */
string* str2array(string str);

/* Returns an outlined box containing str */
string box(string str);

/* Returns the portion of str between begin_str and end_str */
string readtag(string str, string begin_str, string end_str);

/* Returns a copy of str padded with spaces to center the text */
string center(string str);

/* Returns a copy of str with all instances of f replaced by r */
string replace(string str, const string f, const string r);

/* Returns a copy of str with ANSI codes removed */
string strip_ansi(string str);

/* Returns a copy of str with Night codes removed */
string strip_night(string str);

/* Returns a copy of str with Night codes interpreted */
string night2(const string str);

/* Displays the contents of file, interpreting all Night codes */
void night2file(char file[]);

/* Returns the contents of file as a string */
string filecontents(char file[]);

#endif /* _NIGHT2_H */
